"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateCurrentDiff = exports.calculateTextDiff = exports.getOriginalContent = exports.writePlanMarkdown = exports.getLocalPlanContent = exports.getLocalPlanResult = exports.PlanJsonName = exports.OriginalPlanMarkdownName = exports.CurrentPlanMarkdownName = exports.PlansDirName = void 0;
const path = __importStar(require("path"));
const fs = __importStar(require("fs/promises"));
const diff_1 = require("diff");
exports.PlansDirName = 'plans';
exports.CurrentPlanMarkdownName = 'plan.md'; // 当前版本（用户编辑的内容，类似 Git 暂存区）
exports.OriginalPlanMarkdownName = '.plan-original.md'; // 原始版本（隐藏，每次 reloadPlan 时更新）
exports.PlanJsonName = 'plan.json';
const getLocalPlanResult = async (genieExtensionPath, conversationId) => {
    try {
        const planJsonPath = path.join(genieExtensionPath, exports.PlansDirName, conversationId, exports.PlanJsonName);
        const planMarkdownPath = path.join(genieExtensionPath, exports.PlansDirName, conversationId, exports.CurrentPlanMarkdownName);
        const jsonContent = await fs.readFile(planJsonPath, 'utf-8');
        const parsedJsonData = JSON.parse(jsonContent);
        // 直接读取 plan.md（当前版本）
        const planMarkdownContent = await fs.readFile(planMarkdownPath, 'utf-8');
        return {
            id: parsedJsonData.id,
            name: parsedJsonData.name,
            overview: parsedJsonData.overview,
            status: parsedJsonData.status,
            hasConfirmed: parsedJsonData.hasConfirmed,
            content: planMarkdownContent,
            design: parsedJsonData.design,
            todolist: parsedJsonData.todolist || [],
            parts: parsedJsonData.parts || [],
        };
    }
    catch (error) {
        throw new Error(`Failed to get local plan result for conversation: ${conversationId}`);
    }
};
exports.getLocalPlanResult = getLocalPlanResult;
const getLocalPlanContent = async (genieExtensionPath, conversationId) => {
    try {
        const planMarkdownPath = path.join(genieExtensionPath, exports.PlansDirName, conversationId, exports.CurrentPlanMarkdownName);
        const planMarkdownContent = await fs.readFile(planMarkdownPath, 'utf-8');
        return planMarkdownContent;
    }
    catch (error) {
        throw new Error(`Failed to get local plan content for conversation: ${conversationId}`);
    }
};
exports.getLocalPlanContent = getLocalPlanContent;
/**
 * 写入markdown内容到plan.md文件（当前版本）
 * @param genieExtensionPath 主扩展的globalStorage路径
 * @param conversationId 对话ID
 * @param markdownContent 要写入的markdown内容
 */
const writePlanMarkdown = async (genieExtensionPath, conversationId, markdownContent) => {
    try {
        const planMarkdownPath = path.join(genieExtensionPath, exports.PlansDirName, conversationId, exports.CurrentPlanMarkdownName);
        // 确保目录存在
        const planDir = path.dirname(planMarkdownPath);
        await fs.mkdir(planDir, { recursive: true });
        // 写入markdown内容
        await fs.writeFile(planMarkdownPath, markdownContent, 'utf-8');
        console.log('[Data] Successfully wrote plan.md for conversation:', conversationId);
    }
    catch (error) {
        console.error('[Data] Failed to write plan.md:', error);
        throw new Error(`Failed to write plan markdown for conversation: ${conversationId}`);
    }
};
exports.writePlanMarkdown = writePlanMarkdown;
/**
 * 计算markdown差异统计
 * @param changes diff变更数组
 * @returns 统计信息
 */
const calculateDiffStats = (changes) => {
    let additions = 0;
    let deletions = 0;
    for (const change of changes) {
        if (change.added) {
            additions += change.count || 0;
        }
        else if (change.removed) {
            deletions += change.count || 0;
        }
    }
    return {
        additions,
        deletions,
        totalChanges: additions + deletions
    };
};
/**
 * 读取原始版本内容（.plan-original.md）
 * @param genieExtensionPath 主扩展的globalStorage路径
 * @param conversationId 对话ID
 * @returns 原始内容，如果文件不存在则返回 null
 */
const getOriginalContent = async (genieExtensionPath, conversationId) => {
    try {
        const originalPlanMarkdownPath = path.join(genieExtensionPath, exports.PlansDirName, conversationId, exports.OriginalPlanMarkdownName);
        const content = await fs.readFile(originalPlanMarkdownPath, 'utf-8');
        return content;
    }
    catch (error) {
        console.log('[Data] No original plan found for conversation:', conversationId);
        return null;
    }
};
exports.getOriginalContent = getOriginalContent;
/**
 * 计算两个文本之间的差异（纯内存比较，不读磁盘）
 * @param originalContent 原始文本内容
 * @param currentContent 当前文本内容
 * @returns diff 结果
 */
const calculateTextDiff = (originalContent, currentContent) => {
    // 对内容进行 trim 处理，屏蔽末尾换行符差异
    const trimmedOriginal = originalContent.trim();
    const trimmedCurrent = currentContent.trim();
    // 如果规范化后内容完全相同，直接返回空 Diff
    if (trimmedOriginal === trimmedCurrent) {
        console.log('[Diff] Content is identical after normalization, no diff');
        return {
            changes: [],
            stats: { additions: 0, deletions: 0, totalChanges: 0 }
        };
    }
    // 计算差异（基于 trim 后的内容）
    const changes = (0, diff_1.diffLines)(trimmedOriginal, trimmedCurrent);
    const stats = calculateDiffStats(changes);
    return { changes, stats };
};
exports.calculateTextDiff = calculateTextDiff;
/**
 * 动态计算当前版本与原始版本的差异（从磁盘读取文件）
 * @param genieExtensionPath 主扩展的globalStorage路径
 * @param conversationId 对话ID
 * @returns diff 结果，如果原始文件不存在则返回 null
 */
const calculateCurrentDiff = async (genieExtensionPath, conversationId) => {
    try {
        const originalContent = await (0, exports.getOriginalContent)(genieExtensionPath, conversationId);
        if (originalContent === null) {
            return null;
        }
        const planMarkdownPath = path.join(genieExtensionPath, exports.PlansDirName, conversationId, exports.CurrentPlanMarkdownName);
        const currentContent = await fs.readFile(planMarkdownPath, 'utf-8');
        return (0, exports.calculateTextDiff)(originalContent, currentContent);
    }
    catch (error) {
        console.error('[Data] Failed to calculate diff:', error);
        return null;
    }
};
exports.calculateCurrentDiff = calculateCurrentDiff;
//# sourceMappingURL=data.js.map